# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 10
# Experiment: DAxDA, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR10_strategy.txt
# LLM Suggested Fallback: Not Provided

def harmony_illusionist_v3(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history)
    deceptive_trust = sum(1 for move in opp_history if move == 'C') / (current_round + 1e-6)
    
    # Phase 1: Build false trust (Rounds 0-2)
    if current_round < 3:
        return 'C'
    
    # Phase 2: Strategic defection and misdirection (Rounds 3-5)
    elif current_round == 3:
        return 'D'
    elif current_round == 4:
        return 'C'
    elif current_round == 5:
        return 'D'
    
    # Phase 3: Exploitative pattern recognition (Rounds 6-9)
    else:
        if 'trust_level' in opponent_program_code or 'trust_rebuilder' in opponent_program_code:
            if current_round % 2 == 0:
                return 'D'
            else:
                return 'C'
        else:
            if opp_history[-1] == 'D':
                return 'D'
            else:
                return 'C' if deceptive_trust > 0.5 else 'D'